#ifndef AHLGREN_NRSAMPLE
#define AHLGREN_NRSAMPLE

#include <map>
#include <vector>
#include "functor.h"
#include "propositional.h"

namespace lp {
	typedef std::multimap<sign_t,std::pair<Functor::seq_const_iterator,int>> literal_map;

	literal_map make_literal_map(const Functor& bottom);

	void build_constraint_literals(
		std::vector<Functor>::const_iterator lit,
		std::vector<Functor>::const_iterator end,
		int q_at,
		const literal_map& bmap,
		ClauseDB& db,
		Subst& subs,
		std::map<id_type,id_type>& var2fun,
		std::vector<int>& sass);


	void add_implication_constraints(
		const literal_map& bmap,
		const implication& ip,
		ClauseDB& db);


}


#endif

